/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.tank;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.BoilerData;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.block.CustomRenderBoundingBoxBlockEntity;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributeHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3611;

public class FluidTankBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IMultiBlockEntityContainer.Fluid,
CustomRenderBoundingBoxBlockEntity,
SidedStorageBlockEntity {
    private static final int MAX_SIZE = 3;
    protected boolean forceFluidLevelUpdate = true;
    protected SmartFluidTank tankInventory = this.createInventory();
    protected FluidTank exposedTank;
    protected class_2338 controller;
    protected class_2338 lastKnownPos;
    protected boolean updateConnectivity = false;
    protected boolean updateCapability = false;
    protected boolean window = true;
    protected int luminosity;
    protected int width = 1;
    protected int height = 1;
    public BoilerData boiler = new BoilerData();
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private LerpedFloat fluidLevel;

    public FluidTankBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(FluidTankBlockEntity.getCapacityMultiplier(), this::onFluidStackChanged);
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.field_11863.field_9236) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti(this);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.method_11016();
        } else if (!this.lastKnownPos.equals((Object)this.field_11867) && this.field_11867 != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateCapability) {
            this.updateCapability = false;
            this.refreshCapability();
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.fluidLevel != null) {
            this.fluidLevel.tickChaser();
        }
        if (this.isController()) {
            this.boiler.tick(this);
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.isController()) {
            this.boiler.updateOcclusion(this);
        }
    }

    @Override
    public class_2338 getLastKnownPos() {
        return this.lastKnownPos;
    }

    @Override
    public boolean isController() {
        return this.controller == null || this.field_11867.method_10263() == this.controller.method_10263() && this.field_11867.method_10264() == this.controller.method_10264() && this.field_11867.method_10260() == this.controller.method_10260();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.field_11863.field_9236) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.field_11867;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.method_11002()) {
            return;
        }
        FluidVariantAttributeHandler handler = FluidVariantAttributes.getHandlerOrDefault((class_3611)newFluidStack.getFluid());
        FluidVariant variant = newFluidStack.getType();
        int luminosity = (int)((float)handler.getLuminance(variant) / 1.2f);
        boolean reversed = handler.isLighterThanAir(variant);
        int maxY = (int)(this.getFillState() * (float)this.height + 1.0f);
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            boolean isBright;
            boolean bl = reversed ? this.height - yOffset <= maxY : (isBright = yOffset < maxY);
            int actualLuminosity = isBright ? luminosity : (luminosity > 0 ? 1 : 0);
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    class_2338 pos = this.field_11867.method_10069(xOffset, yOffset, zOffset);
                    FluidTankBlockEntity tankAt = (FluidTankBlockEntity)ConnectivityHandler.partAt(this.method_11017(), (class_1922)this.field_11863, pos);
                    if (tankAt == null) continue;
                    this.field_11863.method_8455(pos, tankAt.method_11010().method_26204());
                    if (tankAt.luminosity == actualLuminosity) continue;
                    tankAt.setLuminosity(actualLuminosity);
                }
            }
        }
        if (!this.field_11863.field_9236) {
            this.method_5431();
            this.sendData();
        }
        if (this.isVirtual()) {
            if (this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
            }
            this.fluidLevel.chase((double)this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    protected void setLuminosity(int luminosity) {
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.luminosity == luminosity) {
            return;
        }
        this.luminosity = luminosity;
        this.updateStateLuminosity();
    }

    protected void updateStateLuminosity() {
        if (this.field_11863.field_9236) {
            return;
        }
        int actualLuminosity = this.luminosity;
        FluidTankBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null || !controllerBE.window) {
            actualLuminosity = 0;
        }
        this.refreshBlockState();
        class_2680 state = this.method_11010();
        if ((Integer)state.method_11654((class_2769)FluidTankBlock.LIGHT_LEVEL) != actualLuminosity) {
            this.field_11863.method_8652(this.field_11867, (class_2680)state.method_11657((class_2769)FluidTankBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(actualLuminosity)), 23);
        }
    }

    public FluidTankBlockEntity getControllerBE() {
        if (this.isController() || !this.method_11002()) {
            return this;
        }
        class_2586 blockEntity = this.field_11863.method_8321(this.controller);
        if (blockEntity instanceof FluidTankBlockEntity) {
            return (FluidTankBlockEntity)blockEntity;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity((long)blocks * FluidTankBlockEntity.getCapacityMultiplier());
        long overflow = this.tankInventory.getFluidAmount() - this.tankInventory.getCapacity();
        if (overflow > 0L) {
            TransferUtil.extract((Storage)this.tankInventory, (Object)((FluidVariant)this.tankInventory.variant), (long)overflow);
        }
        this.forceFluidLevelUpdate = true;
    }

    @Override
    public void removeController(boolean keepFluids) {
        if (this.field_11863.field_9236) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.boiler.clear();
        this.onFluidStackChanged(this.tankInventory.getFluid());
        class_2680 state = this.method_11010();
        if (FluidTankBlock.isTank(state)) {
            state = (class_2680)state.method_11657((class_2769)FluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (class_2680)state.method_11657((class_2769)FluidTankBlock.TOP, (Comparable)Boolean.valueOf(true));
            state = (class_2680)state.method_11657(FluidTankBlock.SHAPE, (Comparable)((Object)(this.window ? FluidTankBlock.Shape.WINDOW : FluidTankBlock.Shape.PLAIN)));
            this.method_10997().method_8652(this.field_11867, state, 23);
        }
        this.refreshCapability();
        this.method_5431();
        this.sendData();
    }

    public void toggleWindows() {
        FluidTankBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        if (be.boiler.isActive()) {
            return;
        }
        be.setWindows(!be.window);
    }

    public void updateBoilerTemperature() {
        FluidTankBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        if (!be.boiler.isActive()) {
            return;
        }
        be.boiler.needsHeatLevelUpdate = true;
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    @Override
    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setWindows(boolean window) {
        this.window = window;
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    class_2338 pos = this.field_11867.method_10069(xOffset, yOffset, zOffset);
                    class_2680 blockState = this.field_11863.method_8320(pos);
                    if (!FluidTankBlock.isTank(blockState)) continue;
                    FluidTankBlock.Shape shape = FluidTankBlock.Shape.PLAIN;
                    if (window) {
                        if (this.width == 1) {
                            shape = FluidTankBlock.Shape.WINDOW;
                        }
                        if (this.width == 2) {
                            FluidTankBlock.Shape shape2 = xOffset == 0 ? (zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NW : FluidTankBlock.Shape.WINDOW_SW) : (shape = zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NE : FluidTankBlock.Shape.WINDOW_SE);
                        }
                        if (this.width == 3 && Math.abs(Math.abs(xOffset) - Math.abs(zOffset)) == 1) {
                            shape = FluidTankBlock.Shape.WINDOW;
                        }
                    }
                    this.field_11863.method_8652(pos, (class_2680)blockState.method_11657(FluidTankBlock.SHAPE, (Comparable)((Object)shape)), 23);
                    class_2586 be = this.field_11863.method_8321(pos);
                    if (be instanceof FluidTankBlockEntity) {
                        FluidTankBlockEntity tankAt = (FluidTankBlockEntity)be;
                        tankAt.updateStateLuminosity();
                    }
                    this.field_11863.method_8398().method_12130().method_15513(pos);
                }
            }
        }
    }

    public void updateBoilerState() {
        if (!this.isController()) {
            return;
        }
        boolean wasBoiler = this.boiler.isActive();
        boolean changed = this.boiler.evaluate(this);
        if (wasBoiler != this.boiler.isActive()) {
            if (this.boiler.isActive()) {
                this.setWindows(false);
            }
            for (int yOffset = 0; yOffset < this.height; ++yOffset) {
                for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                    for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                        class_2586 class_25862 = this.field_11863.method_8321(this.field_11867.method_10069(xOffset, yOffset, zOffset));
                        if (!(class_25862 instanceof FluidTankBlockEntity)) continue;
                        FluidTankBlockEntity fbe = (FluidTankBlockEntity)class_25862;
                        fbe.refreshCapability();
                    }
                }
            }
        }
        if (changed) {
            this.notifyUpdate();
            this.boiler.checkPipeOrganAdvancement(this);
        }
    }

    @Override
    public void setController(class_2338 controller) {
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.method_5431();
        this.sendData();
    }

    private void refreshCapability() {
        this.exposedTank = this.handlerForCapability();
    }

    private FluidTank handlerForCapability() {
        return this.isController() ? (this.boiler.isActive() ? this.boiler.createHandler() : this.tankInventory) : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new FluidTank(0L));
    }

    @Override
    public class_2338 getController() {
        return this.isController() ? this.field_11867 : this.controller;
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().method_1012((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    @Nullable
    public FluidTankBlockEntity getOtherFluidTankBlockEntity(class_2350 direction) {
        class_2586 otherBE = this.field_11863.method_8321(this.field_11867.method_10093(direction));
        if (otherBE instanceof FluidTankBlockEntity) {
            return (FluidTankBlockEntity)otherBE;
        }
        return null;
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        FluidTankBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        if (controllerBE.boiler.addToGoggleTooltip(tooltip, isPlayerSneaking, controllerBE.getTotalTankSize())) {
            return true;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, controllerBE.getFluidStorage(null));
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        class_2338 controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        int prevLum = this.luminosity;
        this.updateConnectivity = compound.method_10545("Uninitialized");
        this.luminosity = compound.method_10550("Luminosity");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.method_10545("LastKnownPos")) {
            this.lastKnownPos = class_2512.method_10691((class_2487)compound.method_10562("LastKnownPos"));
        }
        if (compound.method_10545("Controller")) {
            this.controller = class_2512.method_10691((class_2487)compound.method_10562("Controller"));
        }
        if (this.isController()) {
            this.window = compound.method_10577("Window");
            this.width = compound.method_10550("Size");
            this.height = compound.method_10550("Height");
            this.tankInventory.setCapacity((long)this.getTotalTankSize() * FluidTankBlockEntity.getCapacityMultiplier());
            this.tankInventory.readFromNBT(compound.method_10562("TankContent"));
            if (this.tankInventory.getSpace() < 0L) {
                try (Transaction t = TransferUtil.getTransaction();){
                    this.tankInventory.extract((FluidVariant)this.tankInventory.variant, -this.tankInventory.getSpace(), (TransactionContext)t);
                    t.commit();
                }
            }
        }
        this.boiler.read(compound.method_10562("Boiler"), this.width * this.width * this.height);
        if (compound.method_10545("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
        }
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.method_11002()) {
                this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(FluidTankBlockEntity.getCapacityMultiplier() * (long)this.getTotalTankSize());
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            float fillState = this.getFillState();
            if (compound.method_10545("ForceFluidLevel") || this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)fillState);
            }
            this.fluidLevel.chase((double)fillState, 0.5, LerpedFloat.Chaser.EXP);
        }
        if (this.luminosity != prevLum && this.method_11002()) {
            this.field_11863.method_8398().method_12130().method_15513(this.field_11867);
        }
        if (compound.method_10545("LazySync")) {
            this.fluidLevel.chase((double)this.fluidLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
        }
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.method_10556("Uninitialized", true);
        }
        compound.method_10566("Boiler", (class_2520)this.boiler.write());
        if (this.lastKnownPos != null) {
            compound.method_10566("LastKnownPos", (class_2520)class_2512.method_10692((class_2338)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.method_10566("Controller", (class_2520)class_2512.method_10692((class_2338)this.controller));
        }
        if (this.isController()) {
            compound.method_10556("Window", this.window);
            compound.method_10566("TankContent", (class_2520)this.tankInventory.writeToNBT(new class_2487()));
            compound.method_10569("Size", this.width);
            compound.method_10569("Height", this.height);
        }
        compound.method_10569("Luminosity", this.luminosity);
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            compound.method_10556("ForceFluidLevel", true);
        }
        if (this.queuedSync) {
            compound.method_10556("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    @Override
    public void writeSafe(class_2487 compound) {
        if (this.isController()) {
            compound.method_10556("Window", this.window);
            compound.method_10569("Size", this.width);
            compound.method_10569("Height", this.height);
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.registerAwardables(behaviours, AllAdvancements.STEAM_ENGINE_MAXED, AllAdvancements.PIPE_ORGAN);
    }

    public FluidTank getTankInventory() {
        return this.tankInventory;
    }

    public int getTotalTankSize() {
        return this.width * this.width * this.height;
    }

    public static int getMaxSize() {
        return 3;
    }

    public static long getCapacityMultiplier() {
        return (long)((Integer)AllConfigs.server().fluids.fluidTankCapacity.get()).intValue() * 81000L;
    }

    public static int getMaxHeight() {
        return (Integer)AllConfigs.server().fluids.fluidTankMaxHeight.get();
    }

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public void setFluidLevel(LerpedFloat fluidLevel) {
        this.fluidLevel = fluidLevel;
    }

    @Override
    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void queueConnectivityUpdate() {
        this.updateConnectivity = true;
    }

    @Override
    public void notifyMultiUpdated() {
        class_2680 state = this.method_11010();
        if (FluidTankBlock.isTank(state)) {
            state = (class_2680)state.method_11657((class_2769)FluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().method_10264() == this.method_11016().method_10264()));
            state = (class_2680)state.method_11657((class_2769)FluidTankBlock.TOP, (Comparable)Boolean.valueOf(this.getController().method_10264() + this.height - 1 == this.method_11016().method_10264()));
            this.field_11863.method_8652(this.method_11016(), state, 6);
        }
        if (this.isController()) {
            this.setWindows(this.window);
        }
        this.onFluidStackChanged(this.tankInventory.getFluid());
        this.updateBoilerState();
        this.method_5431();
    }

    @Override
    public void setExtraData(@Nullable Object data) {
        if (data instanceof Boolean) {
            this.window = (Boolean)data;
        }
    }

    @Override
    @Nullable
    public Object getExtraData() {
        return this.window;
    }

    @Override
    public Object modifyExtraData(Object data) {
        if (data instanceof Boolean) {
            Boolean windows = (Boolean)data;
            windows = windows | this.window;
            return windows;
        }
        return data;
    }

    @Override
    public class_2350.class_2351 getMainConnectionAxis() {
        return class_2350.class_2351.field_11052;
    }

    @Override
    public int getMaxLength(class_2350.class_2351 longAxis, int width) {
        if (longAxis == class_2350.class_2351.field_11052) {
            return FluidTankBlockEntity.getMaxHeight();
        }
        return this.getMaxWidth();
    }

    @Override
    public int getMaxWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public boolean hasTank() {
        return true;
    }

    @Override
    public long getTankSize(int tank) {
        return FluidTankBlockEntity.getCapacityMultiplier();
    }

    @Override
    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    @Override
    public FluidTank getTank(int tank) {
        return this.tankInventory;
    }

    @Override
    public FluidStack getFluid(int tank) {
        return this.tankInventory.getFluid().copy();
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 direction) {
        if (this.exposedTank == null) {
            this.refreshCapability();
        }
        return this.exposedTank;
    }
}

